/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs.resource;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.component.dependency.DependencyArtifact;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent$;
import org.mule.weave.lsp.project.events.OnDependencyArtifactResolved;
import org.mule.weave.lsp.services.events.AgentStartedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnAgentStarted;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\f\u0018\u0001\u0011B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005k!A\u0011\t\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00036\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u0002&\u0001\t\u0003Y\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007K\u0002\u0001\u000b\u0011B*\t\u000f\u0019\u0004!\u0019!C\u0005O\"1!\u0010\u0001Q\u0001\n!Dqa\u001f\u0001C\u0002\u0013%A\u0010\u0003\u0004\u007f\u0001\u0001\u0006I! \u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0001bCA\b\u0001\u0001\u0007\t\u0019!C\u0005\u0003#A1\"!\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004!Q\u0011q\u0004\u0001\t\u0006\u0004%\t!!\t\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005\u0005\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\ti\u0005\u0001C!\u0003\u001f\u0012AdQ;ti>lGj\\1eKJ\u0014Vm]8ve\u000e,'+Z:pYZ,'O\u0003\u0002\u00193\u0005A!/Z:pkJ\u001cWM\u0003\u0002\u001b7\u0005\u0019aOZ:\u000b\u0005qi\u0012a\u00017ta*\u0011adH\u0001\u0006o\u0016\fg/\u001a\u0006\u0003A\u0005\nA!\\;mK*\t!%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\r\u0019Hm\u001b\u0006\u0003au\t!A\u001e\u001a\n\u0005Ij#!F,fCZ,'+Z:pkJ\u001cWMU3t_24XM]\u0001\u0007Y>\fG-\u001a:\u0016\u0003U\u0002\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d(\u001b\u0005I$B\u0001\u001e$\u0003\u0019a$o\\8u}%\u0011AhJ\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=O\u00059An\\1eKJ\u0004\u0013!\u00044jY\u0016,\u0005\u0010^3og&|g.\u0001\bgS2,W\t\u001f;f]NLwN\u001c\u0011\u0002\u0011\u00154XM\u001c;CkN\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%\u0001E%oi\u0016\u0014h.\u00197Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q!AJT(Q!\ti\u0005!D\u0001\u0018\u0011\u0015\u0019d\u00011\u00016\u0011\u0015\te\u00011\u00016\u0011\u0015\u0019e\u00011\u0001E\u00035\u0011Xm]8ve\u000e,7)Y2iKV\t1\u000b\u0005\u0003U;VzV\"A+\u000b\u0005Y;\u0016!B2bG\",'B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011!lW\u0001\u0007O>|w\r\\3\u000b\u0003q\u000b1aY8n\u0013\tqVKA\u0003DC\u000eDW\rE\u0002'A\nL!!Y\u0014\u0003\r=\u0003H/[8o!\ta3-\u0003\u0002e[\tiq+Z1wKJ+7o\\;sG\u0016\faB]3t_V\u00148-Z\"bG\",\u0007%A\nve&$vNT1nK&#WM\u001c;jM&,'/F\u0001i!\u0011Ig.\u000e9\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011QnJ\u0001\u000bG>dG.Z2uS>t\u0017BA8k\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0013Y\f'/[1cY\u0016\u001c(BA;w\u0003\r\t7\u000f\u001e\u0006\u0003o>\na\u0001]1sg\u0016\u0014\u0018BA=s\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJ\fA#\u001e:j)>t\u0015-\\3JI\u0016tG/\u001b4jKJ\u0004\u0013\u0001G8sS\u001eLg.\u00197GS2,WK]5U_N#XOY+sSV\tQ\u0010\u0005\u0003j]V*\u0014!G8sS\u001eLg.\u00197GS2,WK]5U_N#XOY+sS\u0002\n\u0011c^3bm\u0016\fu-\u001a8u'\u0016\u0014h/[2f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaG\u0001\u0006C\u001e,g\u000e^\u0005\u0005\u0003\u001b\t9AA\tXK\u00064X-Q4f]R\u001cVM\u001d<jG\u0016\fQc^3bm\u0016\fu-\u001a8u'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u0014\u0002\u0016%\u0019\u0011qC\u0014\u0003\tUs\u0017\u000e\u001e\u0005\n\u00037q\u0011\u0011!a\u0001\u0003\u0007\t1\u0001\u001f\u00132\u0003I9X-\u0019<f\u0003\u001e,g\u000e^*feZL7-\u001a\u0011\u0002\u0017M$XOY:G_2$WM]\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0002j_*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\u001d\"\u0001\u0002$jY\u0016\f\u0001b]3u\u0003\u001e,g\u000e\u001e\u000b\u0005\u0003'\t9\u0004C\u0004\u0002:E\u0001\r!a\u0001\u0002\u0019\u0005<WM\u001c;TKJ4\u0018nY3\u0002%M$XOY:N_\u0012,H.Z:G_2$WM]\u0001\u0015]\u0006lW-\u00133f]RLg-[3s\u001f\u001a\u001cF/\u001e2\u0015\t\u0005\u0005\u00131\t\t\u0004M\u0001\u0004\bBBA#'\u0001\u0007Q'A\u0002ve&\fAD\\1nK&#WM\u001c;jM&,'o\u00144Pe&<\u0017N\\1m\r&dW\r\u0006\u0003\u0002B\u0005-\u0003BBA#)\u0001\u0007Q'A\u0004sKN|GN^3\u0015\u0007}\u000b\t\u0006\u0003\u0004\u0002TU\u0001\r\u0001]\u0001\u0005]\u0006lW\r")
public class CustomLoaderResourceResolver
implements WeaveResourceResolver {
    private File stubsFolder;
    private final String loader;
    private final String fileExtension;
    private final Cache<String, Option<WeaveResource>> org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache;
    private final HashMap<String, NameIdentifier> uriToNameIdentifier;
    private final HashMap<String, String> originalFileUriToStubUri;
    private WeaveAgentService weaveAgentService;
    private volatile boolean bitmap$0;

    public String loader() {
        return this.loader;
    }

    public String fileExtension() {
        return this.fileExtension;
    }

    public Cache<String, Option<WeaveResource>> org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache() {
        return this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache;
    }

    private HashMap<String, NameIdentifier> uriToNameIdentifier() {
        return this.uriToNameIdentifier;
    }

    private HashMap<String, String> originalFileUriToStubUri() {
        return this.originalFileUriToStubUri;
    }

    private WeaveAgentService weaveAgentService() {
        return this.weaveAgentService;
    }

    private void weaveAgentService_$eq(WeaveAgentService x$1) {
        this.weaveAgentService = x$1;
    }

    private File stubsFolder$lzycompute() {
        CustomLoaderResourceResolver customLoaderResourceResolver = this;
        synchronized (customLoaderResourceResolver) {
            if (!this.bitmap$0) {
                this.stubsFolder = Files.createTempDirectory(this.loader(), new FileAttribute[0]).toFile();
                this.bitmap$0 = true;
            }
        }
        return this.stubsFolder;
    }

    public File stubsFolder() {
        if (!this.bitmap$0) {
            return this.stubsFolder$lzycompute();
        }
        return this.stubsFolder;
    }

    public void setAgent(WeaveAgentService agentService) {
        this.weaveAgentService_$eq(agentService);
    }

    public File stubsModulesFolder() {
        return this.stubsFolder();
    }

    public Option<NameIdentifier> nameIdentifierOfStub(String uri) {
        return this.uriToNameIdentifier().get((Object)uri);
    }

    public Option<NameIdentifier> nameIdentifierOfOriginalFile(String uri2) {
        return this.originalFileUriToStubUri().get((Object)uri2).flatMap((Function1 & Serializable & scala.Serializable)uri -> this.nameIdentifierOfStub((String)uri));
    }

    public Option<WeaveResource> resolve(NameIdentifier name) {
        if (name.loader().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(this.loader())))) {
            return (Option)this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().get((Object)name.toString(), () -> {
                Option<WeaveResource> maybeResource = this.weaveAgentService().resolveModule(name.toString(), this.loader()).get(30L, TimeUnit.SECONDS);
                return maybeResource.map((Function1 & Serializable & scala.Serializable)wr -> {
                    File file = new File(this.stubsModulesFolder(), new StringBuilder(0).append(name.toString().replace(NameIdentifier$.MODULE$.SEPARATOR(), File.separator)).append(WeaveFile$.MODULE$.fileExtension()).toString());
                    file.getParentFile().mkdirs();
                    Path tmpFilePath = file.toPath();
                    String stubUri = tmpFilePath.toUri().toString();
                    this.uriToNameIdentifier().put((Object)stubUri, (Object)name);
                    this.originalFileUriToStubUri().put((Object)wr.url(), (Object)stubUri);
                    FileUtils.writeStringToFile((File)tmpFilePath.toFile(), (String)wr.content(), (Charset)StandardCharsets.UTF_8);
                    return WeaveResource$.MODULE$.apply(tmpFilePath.toFile().toURI().toString(), wr.content());
                });
            });
        }
        return None$.MODULE$;
    }

    public CustomLoaderResourceResolver(String loader, String fileExtension, InternalEventBus eventBus) {
        this.loader = loader;
        this.fileExtension = fileExtension;
        WeaveResourceResolver.$init$((WeaveResourceResolver)this);
        this.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache = CacheBuilder.newBuilder().build();
        this.uriToNameIdentifier = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.originalFileUriToStubUri = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (uri.endsWith(new StringBuilder(1).append(".").append(this.$outer.fileExtension()).toString())) {
                    this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DependencyArtifactResolvedEvent$.MODULE$.ARTIFACT_RESOLVED(), new OnDependencyArtifactResolved(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onArtifactsResolved(DependencyArtifact[] artifacts) {
                this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(AgentStartedEvent$.MODULE$.AGENT_STARTED(), new OnAgentStarted(this){
            private final /* synthetic */ CustomLoaderResourceResolver $outer;

            public void onAgentStarted() {
                this.$outer.org$mule$weave$lsp$vfs$resource$CustomLoaderResourceResolver$$resourceCache().invalidateAll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

