package org.mule.weave.v2.metadata.api

import org.mule.metadata.api.model.MetadataFormat
import org.mule.metadata.api.model.MetadataType
import org.mule.weave.v2.cache.service.Cache
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.WeaveType

import scala.collection.JavaConverters._

class TypesConverter {

  private val weaveConverter = new WeaveTypesConverter()

  private val metadataTypeToWeaveType = Cache.builder()
    .maximumSize(1000)
    .weakKeys()
    .build[MetadataType, WeaveType]()

  def toWeaveType(metadataType: MetadataType): WeaveType = {
    metadataTypeToWeaveType.get(metadataType, (_) => weaveConverter.toWeaveType(metadataType))
  }

  def toMuleType(wt: WeaveType, metadataFormat: MetadataFormat, sample: Option[String] = None, mimeTypeProperties: Map[String, String] = Map(), skipLiterals: Boolean = false): MetadataType = {
    val result = if (mimeTypeProperties.isEmpty) {
      metadataTypeToWeaveType.asMap().entrySet().asScala
        .find((tuple) => {
          if (tuple.getKey.getMetadataFormat.getId.equalsIgnoreCase(metadataFormat.getId)) {
            val value: WeaveType = tuple.getValue
            TypeHelper.areEqualStructurally(value, wt, compareMetadataConstraints = true)
          } else {
            false
          }
        })
        .map(_.getKey)
    } else {
      None
    }
    result.getOrElse(MuleTypesConverter.toMuleType(wt, metadataFormat, sample, mimeTypeProperties, skipLiterals))
  }

}
