package org.mule.weave.v2.nocache.cache.service.builder

import org.mule.weave.v2.cache.service.Cache
import org.mule.weave.v2.cache.service.builder.CacheBuilder
import org.mule.weave.v2.nocache.cache.service.NoCache

import java.time.Duration

class NoCacheBuilder extends CacheBuilder {
  override def maximumSize(size: Long): CacheBuilder = {
    this
  }

  override def weakKeys(): CacheBuilder = {
    this
  }

  override def weakValues(): CacheBuilder = {
    this
  }

  override def expireAfterWrite(duration: Duration): CacheBuilder = {
    this
  }

  override def build[K, V](): Cache[K, V] = {
    new NoCache[K, V](None)
  }

  override def build[K, V](provider: K => V): Cache[K, V] = {
    new NoCache[K, V](Some(provider))
  }
}

