package org.mule.weave.v2.api.expression

import org.mule.weave.v2.api.tooling.expression.ArrayExpression
import org.mule.weave.v2.api.tooling.expression.AssignmentExpression
import org.mule.weave.v2.api.tooling.expression.ComplexExpression
import org.mule.weave.v2.api.tooling.expression.Expression
import org.mule.weave.v2.api.tooling.expression.FunctionCallExpression
import org.mule.weave.v2.api.tooling.expression.LiteralExpression
import org.mule.weave.v2.api.tooling.expression.MappingExpression
import org.mule.weave.v2.api.tooling.expression.ObjectExpression
import org.mule.weave.v2.api.tooling.expression.UndefinedExpression
import org.mule.weave.v2.api.tooling.expression.ValueSelectionExpression
import org.mule.weave.v2.api.tooling.location.Location
import org.mule.weave.v2.parser.location.UnknownLocation

import java.util.Optional

case class DWLiteralExpression(
  outputPath: String,
  location: Location = UnknownLocation,
  inputPath: Optional[String] = Optional.empty()) extends LiteralExpression

case class DWObjectExpression(
  children: Array[Expression],
  outputPath: String,
  location: Location = UnknownLocation) extends ObjectExpression

case class DWAssignmentExpression(
  keyExpression: Expression,
  valueExpression: Expression,
  outputPath: String,
  location: Location = UnknownLocation) extends AssignmentExpression

case class DWMappingExpression(
  collection: Expression,
  itemBinding: String,
  indexBinding: String,
  mapBody: Expression,
  outputPath: String,
  location: Location = UnknownLocation) extends MappingExpression

case class DWComplexExpression(
  outputPath: String,
  location: Location = UnknownLocation,
  inputPaths: Array[String]) extends ComplexExpression

case class DWArrayExpression(
  elements: Array[Expression],
  outputPath: String,
  location: Location = UnknownLocation) extends ArrayExpression

case class DWFunctionCallExpression(
  parameters: Array[Expression],
  name: String,
  outputPath: String,
  location: Location = UnknownLocation) extends FunctionCallExpression

case class DWUndefinedExpression(
  error: String,
  outputPath: String,
  location: Location = UnknownLocation) extends UndefinedExpression

case class DWValueSelectionExpression(
  source: Expression,
  attribute: Expression,
  outputPath: String,
  inputPath: Optional[String],
  location: Location = UnknownLocation) extends ValueSelectionExpression