package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.literals.StringLiteral
import org.mule.weave.v2.grammar.literals.{ BaseExpression, Literals }
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.grammar.structure.Attributes
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.schema._
import org.parboiled2.Rule1

trait Schemas extends PositionTracking with Tokens with Functions with StringLiteral with Literals with Attributes with BaseExpression {
  this: Schemas with Grammar =>

  def schema: Rule1[SchemaNode] = rule {
    pushPosition ~ (curlyBracketsStart ~!~ zeroOrMore(property | conditionalProperty).separatedBy(commaSep) ~ quiet(optional(commaSep)) ~!~ (curlyBracketsEnd | fail("'}' for the Metadata.")) ~> createSchemaNode) ~ injectPosition
  }

  def property: Rule1[SchemaPropertyNode] = namedRule("property") {
    pushPosition ~ ((nameString | string) ~ ws ~ propertyValue ~> createPropertyNode) ~ injectPosition
  }

  def conditionalProperty: Rule1[SchemaPropertyNode] = namedRule("property") {
    pushPosition ~ (parenStart ~!~ (nameString | string) ~ ws ~ propertyValue ~ parenEnd ~ ws ~ ifKeyword ~ ws ~ enclosedExpr ~> createConditionalPropertyNode) ~ injectPosition
  }

  private def propertyValue = rule {
    ((objFieldSep ~ (expr | missingExpression("Missing Schema Property Value"))) | missingToken("Missing Schema Property Value. i.e {unit: 'milliseconds'}.", ":"))
  }

  val createPropertyNode: (AstNode, AstNode) => SchemaPropertyNode = (name: AstNode, value: AstNode) => SchemaPropertyNode(name, value, None)

  val createConditionalPropertyNode: (AstNode, AstNode, AstNode) => SchemaPropertyNode = (name: AstNode, value: AstNode, expression: AstNode) => SchemaPropertyNode(name, value, Some(expression))

  val createSchemaNode: (Seq[SchemaPropertyNode]) => SchemaNode = (properties: Seq[SchemaPropertyNode]) => SchemaNode(properties)
}
