package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.CustomTypeResolver
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

class FieldBasedUpdateSelectorResolver(resolver: CustomTypeResolver) extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val nameToSelect = node.incomingType(EdgeLabels.PROPERTY_SELECTOR).get
    val selectOver = node.incomingType(EdgeLabels.VALUE).get
    resolver.resolve(Seq(selectOver, nameToSelect), ctx, node, AnyType())
  }
}
