package org.mule.weave.v2.editor

import org.mule.weave.v2.parser.location.WeaveLocation

case class FoldingRegion(location: WeaveLocation, kind: Int) {}

object RegionKind {

  val COMMENTS = 0
  val FUNCTIONS = 1
  val CODE_BLOCKS = 2
  val OBJECTS = 3
  val ARRAYS = 4
  val PATTERN_MATCHER = 5
  val IMPORT = 6

  val KindNames = Seq(
    "COMMENT", "FUNCTION", "CODE_BLOCK", "OBJECT", "ARRAY", "PATTERN_MATCHER", "IMPORT")

  def nameOf(kind: Int): String = {
    KindNames(kind)
  }
}
