package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.WeaveEditorSupport
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode

class CreateNamespaceDeclarationQuickFix(val editorSupport: WeaveEditorSupport, trn: NamespaceNode, argName: String) extends TemplateBasedQuickFixAction {

  override protected def createTemplate(): Template = {
    val template = Template().add(s"ns ${argName} ")
    template.placeHolder("http://")
    template.newLine()
    template
  }

  override val element: AstNode = trn
}