package org.mule.weave.v2.inspector

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.UnnecessaryIfExpression
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.conditional.IfNode
import org.mule.weave.v2.parser.ast.structure.BooleanNode
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware

object UnnecessaryIfBlockInspector extends CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware] {

  override def inspect(node: AstNode, scopeData: AstNodeResultAware[_] with ScopeNavigatorResultAware, parsingContext: ParsingContext): Unit = {
    node match {
      case ifnode @ IfNode(BooleanNode("true", _), condition, BooleanNode("false", _), _) => {
        //if(x) true else false
        parsingContext.messageCollector.warning(UnnecessaryIfExpression(ifnode, condition, false), ifnode.location())
      }
      case ifnode @ IfNode(BooleanNode("false", _), condition, BooleanNode("true", _), _) => {
        //if(x) false else true
        parsingContext.messageCollector.warning(UnnecessaryIfExpression(ifnode, condition, true), ifnode.location())
      }
      case _ =>
    }
  }
}

class UnnecessaryIfQuickFixAction(ifNode: AstNode, ifCondition: AstNode, negate: Boolean) extends QuickFixAction {
  override def run(document: WeaveTextDocument): Unit = {
    document.delete(ifNode.location().startPosition.index, ifNode.location().endPosition.index)
    document.insert((if (negate) "!(" else "") + CodeGenerator.generate(ifCondition) + (if (negate) ")" else ""), ifNode.location().startPosition.index)
  }
}
