package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentsNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParameterNode
import org.mule.weave.v2.scope.ScopesNavigator

class AnnotationArgumentNodeDefaultValuePhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware]() extends CompilationPhase[T, T] {
  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val scopeNavigator: ScopesNavigator = source.scope
    val annotationNodes: Seq[AnnotationNode] = source.scope.astNavigator().allWithType(classOf[AnnotationNode])
    annotationNodes.foreach(an => {
      val maybeAnnotationRef = scopeNavigator.resolveVariable(an.name)
      if (maybeAnnotationRef.isDefined) {
        val annotationRef = maybeAnnotationRef.get
        val maybeAnnotationDirectiveNode = annotationRef.scope.astNavigator().parentWithType(annotationRef.referencedNode, classOf[AnnotationDirectiveNode])
        if (maybeAnnotationDirectiveNode.isDefined) {
          val adn = maybeAnnotationDirectiveNode.get
          val maybeArgs: Option[AnnotationArgumentsNode] = an.args
          val missingAnnotationArgumentsNodesWithDefaultValue: Seq[AnnotationArgumentNode] = collectMissingAnnotationParameterNodeWithDefaultValue(adn.params.paramList, maybeArgs).map(p => {
            val argNode = AnnotationArgumentNode(p.nameIdentifier, p.defaultValue.get)
            argNode.annotate(InjectedNodeAnnotation())
            argNode
          })
          if (missingAnnotationArgumentsNodesWithDefaultValue.nonEmpty) {
            val alreadyDefinedArgs = maybeArgs.map(_.args).getOrElse(Seq())
            val annotationArgumentsNodeWithDefaults = AnnotationArgumentsNode(alreadyDefinedArgs ++ missingAnnotationArgumentsNodesWithDefaultValue)
            an.args = Some(annotationArgumentsNodeWithDefaults)
          }
        }
      }
    })

    SuccessResult(source, context)
  }

  private def collectMissingAnnotationParameterNodeWithDefaultValue(params: Seq[AnnotationParameterNode], maybeArgs: Option[AnnotationArgumentsNode]): Seq[AnnotationParameterNode] = {
    val paramsWithDefaultValues: Seq[AnnotationParameterNode] = params.filter(_.defaultValue.isDefined)
    if (maybeArgs.isEmpty) {
      paramsWithDefaultValues
    } else {
      val args = maybeArgs.get
      paramsWithDefaultValues.filter(p => {
        !args.args.exists(arg => {
          arg.name == p.nameIdentifier
        })
      })
    }
  }

}
