package org.mule.weave.v2.sdk

import java.io.InputStream

import scala.io.Source._

object ClassLoaderResourceProvider extends ResourceProvider {
  override def resolveResource(name: String): Option[String] = {
    val asStream: InputStream = getClass.getClassLoader.getResourceAsStream(name)
    Option(asStream).map(fromInputStream(_, "UTF-8").mkString)
  }
}
