package org.mule.weave.v2.api.tooling.impl

import org.mule.weave.v2.api.tooling.ast.DWAstNode
import org.mule.weave.v2.api.tooling.ast.DWAstNodeFactory
import org.mule.weave.v2.api.tooling.internal.DefaultDWAstNode
import org.mule.weave.v2.parser.ModuleParser
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.sdk.ParsingContextFactory
import org.mule.weave.v2.sdk.WeaveResourceFactory

import java.util.Optional

class DefaultDWAstNodeFactory extends DWAstNodeFactory {

  @Override
  def parse(content: String): Optional[DWAstNode] = {
    val weaveResource = WeaveResourceFactory.fromContent(content)

    val parsingContext = ParsingContextFactory.createParsingContext(false)

    val parseResult = ModuleParser.parse(ModuleParser.parsingPhase, weaveResource, parsingContext)
    if (parseResult.hasErrors || !parseResult.hasResult) {
      return Optional.empty.asInstanceOf[Optional[DWAstNode]]
    }

    val result = parseResult.getResult
    val node = result.astNode
    Optional.of(DefaultDWAstNode(node, new AstNavigator(node), Option.empty, Option.empty))
  }

}

