package org.mule.weave.v2.grammar.structure

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.literals.StringLiteral
import org.mule.weave.v2.grammar.literals.UriLiteral
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.structure.UriNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.parboiled2._

trait Namespaces extends PositionTracking with Tokens with StringLiteral with UriLiteral {
  this: Namespaces with Grammar =>

  val createNamespaceDirective = (annotations: Seq[AnnotationNode], prefix: NameIdentifier, url: UriNode) => {
    NamespaceDirective(prefix, url, annotations)
  }
  val createNamespaceNode = (prefix: NameIdentifier) => {
    Some(NamespaceNode(prefix))
  }

  def namespace: Rule1[Option[NamespaceNode]] = namedRule("Namespace") {
    atomic(declaredNamespace | noNamespace)
  }

  def noNamespace: Rule1[Option[NamespaceNode]] = rule {
    push(None)
  }

  def declaredNamespace: Rule1[Option[NamespaceNode]] = namedRule("Namespace") {
    pushPosition ~ (nameIdentifierNode ~ prefixSeparatorKeyword ~> createNamespaceNode) ~ injectPosition
  }

  def namespaceDirective: Rule1[NamespaceDirective] = namedRule("ns") {
    pushPosition ~ (
      annotations ~
      namespaceDirectiveName ~!~
      ((nameIdentifierNode ~ fws) | missingIdentifier("Missing namespace name")) ~!~
      (uri | missingUriNode()) ~> createNamespaceDirective) ~ injectPosition
  }

}
