package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.api.tooling.internal.DefaultDWAstNode
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.scope.ScopesNavigator

class CanonicalAnnotationProcessingPhase[R <: AstNode, T <: AstNodeResultAware[R] with DummyScopeNavigatorAware]() extends CompilationPhase[T, T] {

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    if (context.hasCanonicalPhaseAnnotationProcessors) {
      val astNavigator = AstNavigator(source.astNode)
      val annotationNodes = AstNodeHelper.collectChildrenWith(source.astNode, classOf[AnnotationNode])
      if (annotationNodes.nonEmpty) {
        val navigator: ScopesNavigator = source.dummyScopesNavigator
        annotationNodes.foreach(f = (annotationNode) => {
          val annotatedNode = astNavigator.parentOf(annotationNode)
          val maybeRef = navigator.resolveVariable(annotationNode.name)
          if (maybeRef.isDefined) {
            val annotationRef = maybeRef.get
            val nameIdentifier = annotationRef.fqnReferenceName
            context.canonicalPhaseAnnotationProcessorFor(nameIdentifier) match {
              case Some(ap) => ap.run(DefaultDWAstNode(annotatedNode.get, astNavigator, None, Some(navigator)), DefaultDWAstNode(annotationNode, astNavigator, None, Some(navigator)), new DefaultAnnotationContext(context))
              case _        =>
            }
          }
        })
      }
    }
    SuccessResult(source, context)
  }

}
