package org.mule.weave.v2.sdk

import org.mule.weave.v2.annotations.WeaveApi

import java.io.File
import java.io.InputStream
import java.net.URL

import org.mule.weave.v2.utils.WeaveConstants

import scala.io.Source

object WeaveResourceFactory {

  @WeaveApi(Seq("data-weave-agent"))
  def fromContent(content: String): WeaveResource = {
    fromContent("Unknown", content)
  }

  def fromContent(url: String, content: String): WeaveResource = {
    WeaveResource(url, content)
  }

  def fromFile(file: File): WeaveResource = {
    val source = Source.fromFile(file, WeaveConstants.default_encoding)
    try {
      WeaveResource(file.toURI.toURL.toExternalForm, source.mkString)
    } finally {
      source.close()
    }
  }

  def fromInputStream(url: String, content: InputStream): WeaveResource = {
    val source = Source.fromInputStream(content, WeaveConstants.default_encoding)
    try {
      WeaveResource(url, source.mkString)
    } finally {
      source.close()
    }
  }

  def fromUrl(url: URL): WeaveResource = {
    val source = Source.fromInputStream(url.openStream(), WeaveConstants.default_encoding)
    try {
      WeaveResource(url.toExternalForm, source.mkString)
    } finally {
      source.close()
    }
  }
}
