package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.parser.PropertyNotDefined
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object ObjectKeyValueSelectorTypeResolver extends BaseValueSelectorCustomTypeResolver {

  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    val maybeNameType = getSelectorNameType(selector)
    if (maybeNameType.isEmpty) {
      Unknown
    } else {
      val name = maybeNameType.get
      leftType match {
        case ObjectType(properties, closed, _) => {
          name.value match {
            case Some(selected) => {
              val filter: Seq[KeyValuePairType] = properties
                .filter((prop) => {
                  prop.key match {
                    case keyType: KeyType => TypeHelper.canBeAssignedTo(keyType.name, name, ctx)
                    case _                => false
                  }
                })
              if (filter.isEmpty) {
                if (closed) {
                  ctx.warning(PropertyNotDefined(selected.name, properties.collect({ case KeyValuePairType(KeyType(NameType(Some(keyname)), _), _, _, _) => keyname.name }), leftType), node)
                  NoMatch(closed)
                } else {
                  Matched(ObjectType().markOptional())
                }
              } else {
                Matched(ObjectType(filter))
              }
            }
            case None => {
              Matched(ObjectType().markOptional())
            }
          }
        }
        case _ => Unknown
      }
    }
  }
}
