package org.mule.weave.v2.utils

import org.mule.weave.v2.parser.phase.VersionCheckerPhase
import org.mule.weave.v2.version.DataWeaveRuntimeVersion
import org.mule.weave.v2.versioncheck.SVersion

case class DataWeaveVersion(
  major: Int = VersionCheckerPhase.getWeaveVersion.major,
  minor: Int = VersionCheckerPhase.getWeaveVersion.minor) extends Ordered[DataWeaveVersion] {

  private lazy val _sVersion: SVersion = SVersion(major, minor, 0)

  override def compare(that: DataWeaveVersion): Int =
    if (this.major < that.major || (this.major == that.major && this.minor < that.minor)) {
      -1
    } else if (this == that) {
      0
    } else {
      1
    }

  override def toString: String = s"$major.$minor"
  def asSVersion(): SVersion = _sVersion
}

object DataWeaveVersion {
  def apply(version: String): DataWeaveVersion = {
    val weaveVersion = version.split('.')
    DataWeaveVersion(weaveVersion(0).toInt, weaveVersion(1).toInt)
  }

  def apply(): DataWeaveVersion = DataWeaveVersion(DataWeaveRuntimeVersion.weaveVersion)
}