package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.literals.BaseExpression
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentsNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.parboiled2.Rule1

trait Annotations extends PositionTracking with Tokens with Identifiers with BaseExpression {
  this: org.mule.weave.v2.grammar.Variables with Grammar =>

  val createAnnotation = (name: NameIdentifier, args: Option[AnnotationArgumentsNode]) => {
    AnnotationNode(name, args)
  }

  val createAnnotationArgs = (args: Option[Seq[AnnotationArgumentNode]]) => {
    AnnotationArgumentsNode(args.getOrElse(Seq()))
  }

  val createAnnotationArg = (name: NameIdentifier, value: AstNode) => {
    AnnotationArgumentNode(name, value)
  }

  val injectAnnotations = (annotations: Seq[AnnotationNode], target: DirectiveNode) => {
    target match {
      case de: AnnotationCapableNode =>
        de.setAnnotations(annotations)
      case _ =>
    }
    target
  }

  val injectAnnotationsToExpression = (annotations: Seq[AnnotationNode], target: AstNode) => {
    target match {
      case de: AnnotationCapableNode =>
        de.setAnnotations(de.codeAnnotations ++ annotations)
      case _ =>
    }
    target
  }

  def annotations = rule {
    zeroOrMore(annotation).separatedBy(fws)
  }

  def oneOrMoreAnnotations = rule {
    oneOrMore(annotation).separatedBy(fws)
  }

  def annotation: Rule1[AnnotationNode] = namedRule("Ref Name") {
    pushPosition ~ (atToken ~!~ namedRef ~ ws ~ optional(annotationArgs) ~> createAnnotation) ~ injectPosition
  }

  def annotationArgs = namedRule("Annotation Arguments") {
    pushPosition ~ (parenStart ~ optional(oneOrMore(annotationArg).separatedBy(commaSep)) ~ (parenEnd | fail("')' for annotation."))) ~> createAnnotationArgs ~ injectPosition
  }

  def annotationArg = namedRule("Annotation Argument") {
    pushPosition ~ (nameIdentifierNode ~!~ ((assignment ~ ws ~ (expr | missingExpression("Missing annotation argument expression e.g @Since(version = '2.3.0')"))) | missingExpression("Missing annotation argument expression e.g @Since(version = '2.3.0')"))) ~> createAnnotationArg ~ injectPosition
  }

}
