package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.parser.ast.AstNode
import org.parboiled2._

import scala.annotation.switch

trait Literals extends BooleanLiteral with DateLiteral with IntegerLiteral with NullLiteral with RegexLiteral with StringLiteral with TypeLiteral with UriLiteral {
  this: Literals with Grammar =>

  def literal: Rule1[AstNode] = rule {
    run {
      (cursorChar: @switch) match {
        case '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' | '-' => number
        case '"' | '\'' | '`' => string
        case 't' => trueLiteral
        case 'f' => falseLiteral
        case 'n' => nullLiteral
        case '/' => regexLiteral
        case '|' => anyDateLiteral
        case _ => MISMATCH
      }
    } // ~ !(ws ~ (attributesStart | objFieldSep))
    // (number | anyDateLiteral | trueLiteral | falseLiteral | nullLiteral | regexLiteral | string) ~ !(ws ~ (attributesStart | objFieldSep))
  }
}
