package org.mule.weave.v2.parser.annotation

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.WeaveLocationCapable
import org.mule.weave.v2.parser.location.WeaveLocation

/**
  * @param location the location of the last element in the array or object, after which the trailing comma should be placed
  */
case class TrailingCommaAnnotation(override val location: WeaveLocation) extends AstNodeAnnotation with WeaveLocationCapable {
  override def name(): String = "TrailingComma"
}

object TrailingCommaAnnotation {
  def annotate(node: AstNode): Unit = {
    val location = node.children().last.location()
    node.annotate(TrailingCommaAnnotation(location))
  }
}