package org.mule.weave.v2.parser.ast.types

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode

case class TypeParametersApplicationListNode(var typeParameters: Seq[WeaveTypeNode] = Seq()) extends AstNode {
  override def children(): Seq[AstNode] = typeParameters

  override protected def doClone(): AstNode = copy(typeParameters.map(_.cloneAst()))

  override def cloneAst(): TypeParametersApplicationListNode = super.cloneAst().asInstanceOf[TypeParametersApplicationListNode]

  override def getKind(): String = DWAstNodeKind.TYPE_PARAMETER_APPLICATION_LIST_NODE
}
