package org.mule.weave.v2.parser.location

import org.mule.weave.v2.api.tooling.location.{ Position => ApiPosition }

trait Position extends ApiPosition with Ordered[Position] {
  def index: Int

  def line: Int

  def column: Int

  def source: () => String

  override def toString: String = "[index: " + index + ", line: " + line + ", column: " + column + "]"

  def compare(that: Position): Int = this.index compare that.index

  override def getIndex: Int = {
    index
  }

  override def getLine: Int = {
    line
  }

  override def getColumn: Int = {
    column
  }

  override def getSource: String = {
    source.apply()
  }
}