package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.grammar.MetadataInjectorOpId
import org.mule.weave.v2.parser.DuplicatedMetadataAnnotation
import org.mule.weave.v2.parser.IgnoredMetadataAnnotation
import org.mule.weave.v2.parser.NoMetadataValueSpecified
import org.mule.weave.v2.parser.annotation.MetadataKeyAstNodeAnnotation
import org.mule.weave.v2.parser.annotation.MetadataKeyValue
import org.mule.weave.v2.parser.annotation.MetadataKeyValueAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNodeWithSchema

class MetadataKeyNodeInjectorPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware]() extends CompilationPhase[T, T] {

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val annotationNodes = AstNodeHelper.collectChildrenWith(source.astNode, classOf[AnnotationNode])
    if (annotationNodes.nonEmpty) {
      annotationNodes.foreach(f = (annotationNode) => {
        val scope = source.scope
        val navigator = scope.astNavigator()
        val maybeAnnotatedNode = navigator.parentOf(annotationNode)
        val maybeRef = scope.resolveVariable(annotationNode.name)
        if (maybeRef.nonEmpty && maybeAnnotatedNode.isDefined) {
          val annotatedNode = maybeAnnotatedNode.get
          val referenceValue = maybeRef.get
          val maybeNode = referenceValue.scope.astNavigator().parentWithType(referenceValue.referencedNode, classOf[AnnotationDirectiveNode])
          if (maybeNode.isDefined) {
            val maybeAnnotation = maybeNode.get.annotation(classOf[MetadataKeyAstNodeAnnotation])
            if (maybeAnnotation.isDefined) {
              val hasMetadataInjection = annotatedNode match {
                case typeNodeWithSchema: WeaveTypeNodeWithSchema if typeNodeWithSchema.asTypeSchema.isDefined => true
                case metadataInjectionNode: BinaryOpNode if MetadataInjectorOpId.equals(metadataInjectionNode.binaryOpId) => true
                case _ => false
              }
              if (hasMetadataInjection) {
                context.messageCollector.warning(IgnoredMetadataAnnotation(annotationNode), annotationNode.location())
              } else {
                val metadataKey = maybeAnnotation.get.value()
                val argNode = AnnotationNodeHelper.arg("value", annotationNode)
                if (argNode.isDefined) {
                  val metadataAstNodeAnnotation = new MetadataKeyValueAstNodeAnnotation(MetadataKeyValue(metadataKey, argNode.get))
                  val metadataAstNodeAnnotations: Seq[MetadataKeyValueAstNodeAnnotation] = annotatedNode.annotationsBy(classOf[MetadataKeyValueAstNodeAnnotation])
                  if (metadataAstNodeAnnotations.exists(mAnnotation => mAnnotation.metadataKeyValue.metadataKey.equals(metadataKey))) {
                    context.messageCollector.warning(DuplicatedMetadataAnnotation(annotationNode), annotationNode.location())
                  } else {
                    annotatedNode.annotate(metadataAstNodeAnnotation)
                  }
                } else {
                  context.messageCollector.warning(NoMetadataValueSpecified(annotationNode), annotationNode.location())
                }
              }
            }
          }
        }
      })
    }
    SuccessResult(source, context)
  }
}
