package org.mule.weave.v2.parser.phase
import org.mule.weave.v2.parser.annotation.TailRecFunctionAnnotation
import org.mule.weave.v2.parser.annotation.TailRecFunctionCallAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class TailRecursiveMarkerPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends CompilationPhase[T, T] {

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val functionDirectiveNodes = source.scope.astNavigator().allWithType(classOf[FunctionDirectiveNode])
    functionDirectiveNodes.foreach(fdn => {
      markTailRec(source, fdn.variable, fdn.literal)
    })
    val varDirectives = source.scope.astNavigator().allWithType(classOf[VarDirective])
    varDirectives.foreach(vardir => {
      markTailRec(source, vardir.variable, vardir.value)
    })

    SuccessResult(source, context)
  }
  private def markTailRec(source: T, variable: NameIdentifier, literal: AstNode): Unit = {
    literal match {
      case fn: FunctionNode =>
        if (AstNodeHelper.isTailRecursiveCallExpression(variable, fn.body, source.scope)) {
          variable.annotate(new TailRecFunctionAnnotation)

          val functionCallNodes = AstNodeHelper.collectChildrenWith(fn.body, classOf[FunctionCallNode])
          functionCallNodes.foreach(fcn => {
            if (AstNodeHelper.isRecursiveFunctionCall(variable, fcn, source.scope)) {
              fcn.annotate(new TailRecFunctionCallAnnotation())
            }
          })
        }
      case _: OverloadedFunctionNode =>
      //TODO add support for overloaded tail rec
      case _                         =>
    }
  }
}
