package org.mule.weave.v2.sdk

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.parser.MessageCollector

import java.io.File
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.BaseParsingContextSettings
import org.mule.weave.v2.parser.phase.ModuleLoader
import org.mule.weave.v2.parser.phase.ModuleLoaderManager
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager
import org.mule.weave.v2.parser.phase.ParsingContext

object ParsingContextFactory {

  @WeaveApi(Seq("data-weave-agent"))
  def createParsingContext(): ParsingContext = {
    ParsingContext(NameIdentifier.anonymous, createDefaultModuleParserManager())
  }

  def createParsingContext(strictMode: Boolean): ParsingContext = {
    ParsingContext(NameIdentifier.anonymous, createDefaultModuleParserManager(), strictMode)
  }

  def createParsingContext(nameIdentifier: NameIdentifier, strictMode: Boolean): ParsingContext = {
    ParsingContext(nameIdentifier, createDefaultModuleParserManager(), strictMode)
  }

  def createParsingContextAttachingDocs(attachDocumentation: Boolean): ParsingContext = {
    ParsingContext(NameIdentifier.anonymous, createDefaultModuleParserManager(), 5, attachDocumentation = attachDocumentation)
  }

  def createParsingContext(moduleParserManager: ModuleParsingPhasesManager): ParsingContext = {
    ParsingContext(NameIdentifier.anonymous, moduleParserManager)
  }

  def createParsingContext(moduleParserManager: ModuleParsingPhasesManager, strictMode: Boolean): ParsingContext = {
    ParsingContext(NameIdentifier.anonymous, moduleParserManager, strictMode)
  }

  def createParsingContext(nameIdentifier: NameIdentifier, moduleParserManager: ModuleParsingPhasesManager): ParsingContext = {
    ParsingContext(nameIdentifier, moduleParserManager)
  }

  def createParsingContext(nameIdentifier: NameIdentifier): ParsingContext = {
    ParsingContext(nameIdentifier, createDefaultModuleParserManager())
  }

  def nameIdentifier(weaveFile: File, baseDir: File = new File(".")): NameIdentifier = {
    NameIdentifierHelper.fromWeaveFilePath(weaveFile.getAbsolutePath.substring(baseDir.getAbsolutePath.length))
  }

  def createDefaultModuleParserManager(additionalLoaders: ModuleLoader*): ModuleParsingPhasesManager = {
    ModuleParsingPhasesManager(createDefaultModuleLoaderManager(additionalLoaders: _*))
  }

  @WeaveApi(Seq("data-weave-agent"))
  def createDefaultModuleLoaderManager(additionalLoaders: ModuleLoader*): ModuleLoaderManager = {
    ModuleLoaderManager(Seq(ModuleLoader(ClassLoaderWeaveResourceResolver())) ++ additionalLoaders, SPIBasedModuleLoaderProvider)
  }

  def createModuleLoaderManager(additionalLoaders: ModuleLoader*): ModuleLoaderManager = {
    ModuleLoaderManager(additionalLoaders, SPIBasedModuleLoaderProvider)
  }

  def createModuleParserManager(additionalLoaders: ModuleLoader*): ModuleParsingPhasesManager = {
    ModuleParsingPhasesManager(ModuleLoaderManager(additionalLoaders: _*))
  }

  def createContextWithSettings(settings: BaseParsingContextSettings): ParsingContext = {
    new ParsingContext(NameIdentifier.anonymous, new MessageCollector, createDefaultModuleParserManager(), settings = settings)
  }

  def createParsingContext(nameIdentifier: NameIdentifier, settings: BaseParsingContextSettings): ParsingContext = {
    new ParsingContext(nameIdentifier, new MessageCollector, createDefaultModuleParserManager(), settings = settings)
  }
}
