package org.mule.weave.v2.ts

object EdgeLabels {

  private val FUNCTION_PREFIX = "function"
  private val CONDITION_PREFIX = "condition"
  private val DEFAULT_VALUE_PREFIX = "default_value"
  private val NAMESPACE_PREFIX = "namespace"

  val DYNAMIC_RETURN_TYPE = EdgeLabel("DYNAMIC_RETURN_TYPE")
  val ARGUMENT = EdgeLabel("argument")
  val FUNCTION = EdgeLabel(FUNCTION_PREFIX)
  //The expression that we are matching against <<payload.foo>> match
  val PATTERN_EXPRESSION = EdgeLabel("pattern_expression")
  //The expression we are matching against
  val CASE_EXPRESSION = EdgeLabel("case_expression")
  //The callback function to call on match
  val MATCH_EXPRESSION = EdgeLabel("match_expression")

  val UPDATE_TO = EdgeLabel("update_to")
  val ATTRIBUTE = EdgeLabel("attribute")
  val LOCAL_NAME = EdgeLabel("localname")
  val PROPERTY_SELECTOR = EdgeLabel("property_selector")
  val NAME = EdgeLabel("name")

  val DEFAULT_VALUE = EdgeLabel(DEFAULT_VALUE_PREFIX)
  val VALUE = EdgeLabel("value")

  val NAMESPACE = EdgeLabel(NAMESPACE_PREFIX)
  val IF_LABEL = EdgeLabel("if")
  val ELSE_LABEL = EdgeLabel("else")

  val CONDITION = EdgeLabel(CONDITION_PREFIX)
  val OUTPUT = EdgeLabel("output")
  val FUNCTION_BODY = EdgeLabel("function_body")
  val HEAD = EdgeLabel("head")
  val HEAD_KEY = EdgeLabel("head_key")
  val HEAD_VALUE = EdgeLabel("head_value")
  val TAIL = EdgeLabel("tail")
  val RETURN_TYPE = EdgeLabel("return_type")
  val TYPE_PARAMETER = EdgeLabel("type_parameter")

  val ORIGINAL_TYPE = EdgeLabel("original_type")
  val BRANCH_CONSTRAINT = EdgeLabel("branch_constraint")

  def CONDITION(index: String): EdgeLabel = {
    EdgeLabel(CONDITION_PREFIX + "-" + index)
  }

  def NAMESPACE_PREFIX(index: String): EdgeLabel = {
    EdgeLabel(NAMESPACE_PREFIX + "-" + index)
  }

  def FUNCTION(index: String): EdgeLabel = {
    EdgeLabel(FUNCTION_PREFIX + "-" + index)
  }

  def DEFAULT_VALUE(argName: String): EdgeLabel = {
    EdgeLabel(argName + "-" + DEFAULT_VALUE)
  }

  def PARAM_TYPE(argName: String): EdgeLabel = {
    EdgeLabel("PARAM_TYPE-" + argName)
  }

}
