package org.mule.weave.v2.utils

object SeqUtils {

  /**
    * This will generate all the permutation of the input.
    *
    * For example if the input is [ [1,2], [3,4] ] it will return [ [1,3], [1,4], [2,3], [2,4] ]
    */
  def combine[A](xs: Traversable[Traversable[A]]): Seq[Seq[A]] = {
    val seqOfSeq = xs.foldLeft(Seq(Seq.empty[A])) {
      (seqAcc, traversableElem) =>
        for (
          a <- seqAcc.view;
          elem <- traversableElem
        ) yield a :+ elem
    }
    seqOfSeq
  }

  def distinctBy[L, E](list: Traversable[L])(f: L => E): Traversable[L] = {
    list.foldLeft((Vector.empty[L], Set.empty[E])) {
      case ((acc, set), item) =>
        val key = f(item)
        if (set.contains(key)) (acc, set)
        else (acc :+ item, set + key)
    }._1.toList
  }

}
