package org.mule.weave.v2.editor.refactor

import org.mule.weave.v2.editor.CodeRefactor
import org.mule.weave.v2.editor.RefactorParameter
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.location.WeaveLocation

class ExtractVariableRefactor(
  introduceDo: Boolean,
  insertSeparator: Boolean,
  insertIntoStringInterpolation: Boolean,
  extractExpression: WeaveLocation,
  placeToInsert: Int,
  scope: WeaveLocation,
  defaultName: String,
  directiveKind: String) extends CodeRefactor {

  override def parameters(): Array[RefactorParameter] = Array(RefactorParameter("variableName", defaultName, "Variable Name"))

  override def run(document: WeaveTextDocument, arguments: Map[String, Any]): Unit = {
    val variableName: String = arguments("variableName").toString
    val variableRef = if (insertIntoStringInterpolation) {
      "\"$(" + variableName + ")\""
    } else {
      variableName
    }
    if (introduceDo) {
      document.insert("\n}", scope.endPosition.index)
      val expressionText: String = document.text(extractExpression.startPosition.index, extractExpression.endPosition.index)
      //Replace old expression with new one
      document.replace(extractExpression.startPosition.index, extractExpression.endPosition.index, variableRef)
      val newExpression: String = s"do {\n\t$directiveKind ${variableName} = ${expressionText}\n\t---\n"
      document.insert(newExpression, placeToInsert)
    } else {
      val expressionText: String = document.text(extractExpression.startPosition.index, extractExpression.endPosition.index)
      document.replace(extractExpression.startPosition.index, extractExpression.endPosition.index, variableRef)

      var newExpression: String = s"\n$directiveKind ${variableName} = ${expressionText}\n"
      if (insertSeparator) {
        newExpression = newExpression + "---\n"
      }
      document.insert(newExpression, placeToInsert)
    }
  }
}
