package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast._
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.ParserPosition
import org.mule.weave.v2.parser.location.WeaveLocation
import org.parboiled2._
import org.parboiled2.support.hlist.::
import org.parboiled2.support.hlist.HNil

trait MappingGrammar extends WhiteSpaceHandling with PositionTracking with Tokens with Directives with Expressions with Variables with Schemas {
  this: org.mule.weave.v2.grammar.MappingGrammar with Grammar =>

  val createDocumentNode = (header: HeaderNode, root: AstNode) => {
    val documentNode = DocumentNode(header, root)
    if (attachDocumentation) {
      assignCommentNodes(documentNode)
    }
    documentNode
  }

  val createHeaderNode = (directives: Seq[DirectiveNode], pos: ParserPosition) => {
    pos :: HeaderNode(directives) :: HNil
  }

  def document: Rule1[DocumentNode] = rule {
    pushPosition ~ ((&(setSyntaxVersion) ~ (mappingWithHeader | mappingNoHeader) ~ ws ~ EOI) ~> createDocumentNode) ~ injectPosition
  }

  private def mappingNoHeader = rule {
    push(HeaderNode.withVersion()) ~ ws ~ content
  }

  private def mappingWithHeader = rule {
    fullHeader ~ ((headerSeparator ~ ws ~ content) | missingExpression("Missing Mapping Expression ie. var a = 1 \n --- \n a "))
  }

  def content = rule {
    optional(comments ~ eol) ~ ws ~ (expr | missingExpression("Missing Body Expression. i.e dw 2.0\n --- \n true")) ~ comments
  }

  def fullHeader: Rule1[HeaderNode] = rule {
    pushPosition ~ (ws ~ optional(comments ~ eol)) ~ (directives ~!~ ws ~ pushPosition ~> createHeaderNode) ~ injectPosition2
  }

  def injectPosition2[A]: Rule[ParserPosition :: ParserPosition :: A :: HNil, A :: HNil] = rule {
    run { (startPos: ParserPosition, endPos: ParserPosition, node: A) =>
      {
        node match {
          case pn: WeaveLocationCapable => {
            pn._location = Some(WeaveLocation(startPos, endPos, resourceName))
          }
          case o: Option[Any] if o.isDefined => {
            o.get match {
              case pn: WeaveLocationCapable => {
                pn._location = Some(WeaveLocation(startPos, endPos, resourceName))
              }
            }
          }
        }
        node
      }
    }
  }

  def resourceName: NameIdentifier

}
