package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware
import org.mule.weave.v2.parser.phase.TypeCheckingResult

/**
  * The inspector manages all The inspections for the different compilation stages
  */
trait Inspector {

  /**
    * Returns the Inspections for the scope check phase
    * @param astNode The AstNode (DocumentNode or ModuleNode)
    * @return The Inspections
    */
  def scopeInspectionsFor[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware](astNode: R): Option[ScopeCodeInspectorPhase[R, T]]

  def typeInspectionsFor[R <: AstNode](astNode: R): Option[TypeCodeInspectorPhase[R]]
}

object NoInspector extends Inspector {
  override def scopeInspectionsFor[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware](astNode: R): Option[ScopeCodeInspectorPhase[R, T]] = {
    None
  }

  override def typeInspectionsFor[R <: AstNode](astNode: R): Option[TypeCodeInspectorPhase[R]] = {
    None
  }
}

class DefaultInspector(scopeInspectors: Seq[CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware]], typeInspectors: Seq[CodeInspector[TypeCheckingResult[_ <: AstNode]]]) extends Inspector {

  override def scopeInspectionsFor[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware](astNode: R): Option[ScopeCodeInspectorPhase[R, T]] = {
    Some(new ScopeCodeInspectorPhase[R, T](scopeInspectors))
  }

  override def typeInspectionsFor[R <: AstNode](astNode: R): Option[TypeCodeInspectorPhase[R]] = {
    Some(new TypeCodeInspectorPhase[R](typeInspectors))
  }
}

object DefaultInspector {
  def apply(
    scopeInspectors: Seq[CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware]],
    typeInspectors: Seq[CodeInspector[TypeCheckingResult[_ <: AstNode]]]): DefaultInspector = {
    new DefaultInspector(scopeInspectors, typeInspectors)
  }
}
