package org.mule.weave.v2.inspector

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class RemoveUnusedImport(id: ImportDirective) extends QuickFixAction {

  override def run(document: WeaveTextDocument): Unit = {
    document.delete(id.location().startPosition.index, id.location().endPosition.index)
  }
}

class RemoveUnusedElement(id: ImportDirective, element: NameIdentifier) extends QuickFixAction {

  override def run(document: WeaveTextDocument): Unit = {
    val importDirective = ImportDirective(id.importedModule, ImportedElements(id.subElements.elements.filter((ie) => !ie.elementName.equals(element))), id.codeAnnotations)
    document.delete(id.location().startPosition.index, id.location().endPosition.index)
    document.insert(CodeGenerator.generate(importDirective).trim, id.location().startPosition.index)
  }
}
