package org.mule.weave.v2.inspector

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.grammar.NotOpId
import org.mule.weave.v2.parser.UnnecessaryDoubleNegation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.operators.UnaryOpNode
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware

object UnnecessaryDoubleNegationInspector extends CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware] {

  override def inspect(node: AstNode, scopeData: AstNodeResultAware[_] with ScopeNavigatorResultAware, parsingContext: ParsingContext): Unit = {
    node match {
      case ifnode @ UnaryOpNode(NotOpId, UnaryOpNode(NotOpId, node, _), _) => {
        //if(!(!x)) 1 else 2
        parsingContext.messageCollector.warning(UnnecessaryDoubleNegation(ifnode, node), ifnode.location())
      }
      case _ =>
    }
  }
}

class UnnecessaryDoubleNegationQuickFixAction(negation: AstNode, expression: AstNode) extends QuickFixAction {
  override def run(document: WeaveTextDocument): Unit = {
    document.delete(negation.location().startPosition.index, negation.location().endPosition.index)
    document.insert(CodeGenerator.generate(expression), negation.location().startPosition.index)
  }
}
