package org.mule.weave.v2.parser.ast.annotation

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

trait AnnotationCapableNode extends AstNode {

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  def setAnnotations(annotations: Seq[AnnotationNode])

  /**
    * Returns the list of code annotations
    *
    * @return
    */
  def codeAnnotations: Seq[AnnotationNode]

  /**
    * Returns the annotation with the given name
    *
    * @param name The name of the annotation
    * @return The annotation if present
    */
  def codeAnnotation(name: NameIdentifier): Option[AnnotationNode] = {
    codeAnnotations.find(_.name.equals(name))
  }

}
