package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.MutableAstNode

case class AttributesNode(var attrs: Seq[AstNode]) extends AstNode with MutableAstNode {

  override def children(): Seq[AstNode] = attrs

  override protected def doClone(): AstNode = {
    copy(attrs.map(_.cloneAst()))
  }

  /**
    * Replace the child node that is equals to the given node with the new one
    *
    * @param toBeReplaced The node to be replaced
    * @param withNode     The replacement
    */
  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    attrs = attrs.map {
      case e if e eq toBeReplaced => withNode
      case other                  => other
    }
  }

  override def getKind(): String = DWAstNodeKind.ATTRIBUTES_NODE
}
