package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class HeadTailObjectNode(var headKey: AstNode, var headValue: AstNode, var tail: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {
  override def children(): Seq[AstNode] = {
    Children(headKey, headValue, tail).++=(codeAnnotations).result()
  }

  override protected def doClone(): AstNode = copy(headKey.cloneAst(), headKey.cloneAst(), tail.cloneAst(), codeAnnotations.map(_.cloneAst()))

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.HEAD_TAIL_OBJECT_NODE
}
