package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.annotation.QuotedStringAnnotation
import org.mule.weave.v2.parser.ast.AstNode

case class StringInterpolationNode(var elements: Seq[AstNode]) extends AstNode {

  def quotedBy(): Option[Char] = {
    val quotedStringAnnotation: Option[QuotedStringAnnotation] = annotation(classOf[QuotedStringAnnotation])
    quotedStringAnnotation.map(_.quoteChar)
  }

  override def children(): Seq[AstNode] = elements

  override protected def doClone(): AstNode = {
    copy(elements.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.STRING_INTERPOLATION_NODE
}
