package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.parser.InvalidDirectiveInDoBlock
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives._
/**
  * Validates that only var, fun, ns and type directives are present.
  */
class DoBlockDirectivesValidation extends AstNodeVerifier {

  val expectedDirectives: Seq[String] = Seq(Tokens.VAR, Tokens.FUNCTION, Tokens.NS, Tokens.TYPE, Tokens.IMPORT)

  def checkDirectives(directives: Seq[DirectiveNode], context: ParsingContext): Unit = {
    for (directive <- directives) {
      directive match {
        case _: VarDirective          =>
        case _: FunctionDirectiveNode =>
        case _: NamespaceDirective    =>
        case _: TypeDirective         =>
        case _: ImportDirective       =>
        case invalidDirective =>
          val message = InvalidDirectiveInDoBlock(expectedDirectives, invalidDirective.name)
          context.messageCollector.error(message, invalidDirective.location())
      }
    }

  }

  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case DoBlockNode(HeaderNode(directives), _, _) => checkDirectives(directives, context)
      case _                                         =>
    }
  }

}
