package org.mule.weave.v2.parser.phase

trait BaseParsingContextSettings {
  def removeShadowedImplicitInputs: Boolean
  def javaModuleLoaderLoadTypes: Boolean

  def javaModuleLoaderDeterministicFunctionsOrdering: Boolean
}

object DefaultParsingContextSettings extends BaseParsingContextSettings {
  override def removeShadowedImplicitInputs: Boolean = true
  override def javaModuleLoaderLoadTypes: Boolean = true

  override def javaModuleLoaderDeterministicFunctionsOrdering: Boolean = true
}

case class ConfigurableParsingContextSettings(removeShadowedImplicitInputs: Boolean, javaModuleLoaderLoadTypes: Boolean, javaModuleLoaderDeterministicFunctionsOrdering: Boolean) extends BaseParsingContextSettings