package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.parser.ast.QName
import org.mule.weave.v2.parser.ast.structure.TimeZoneNode
import org.mule.weave.v2.ts.CustomTypeResolver
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.NumberType
import org.mule.weave.v2.ts.StringType
import org.mule.weave.v2.ts.TimeZoneType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object ZonedInstantValueSelectorTypeResolver extends CustomTypeResolver {

  override def resolve(actualTypes: Seq[WeaveType], ctx: WeaveTypeResolutionContext, node: TypeNode, resolvedReturnType: WeaveType): Option[WeaveType] = {
    actualTypes(1) match {
      case StringType(Some(strValue)) =>
        if (strValue == TimeZoneNode.TIMEZONE) {
          Some(TimeZoneType())
        } else {
          Some(NumberType())
        }

      case NameType(Some(QName(name, ns))) =>
        if (name == TimeZoneNode.TIMEZONE) {
          Some(TimeZoneType())
        } else {
          Some(NumberType())
        }

      case _ => Some(NumberType())
    }
  }
}
