package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.NoCoercionAvailableMessage
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.TypeCoercer
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.TypeType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeCloneHelper
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object AsTypeResolver extends WeaveTypeResolver {

  override def supportsPartialResolution() = true

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val lhs = node.incomingEdges().head
    val rhs = node.incomingEdges().apply(1)
    rhs.mayBeIncomingType().flatMap({
      case TypeType(coercedType) if (lhs.incomingTypeDefined()) => {
        val actualType = lhs.incomingType()
        if (TypeHelper(ctx).canBeAssignedTo(actualType, coercedType, ctx)) {
          //This cases is when we do as Object {class: "foo"} so we don't want to loose the structure
          val newType = actualType.cloneType()
          WeaveTypeCloneHelper.copyMetadataTo(coercedType, newType)
          Some(newType)
        } else {
          val maybeType = TypeCoercer.coerce(coercedType, actualType, ctx)
          if (maybeType.isEmpty) {
            if (TypeHelper(ctx).collectTypeParameters(actualType).isEmpty) {
              ctx.warning(NoCoercionAvailableMessage(actualType, coercedType), node)
            }
            Some(coercedType)
          } else {
            val coerced = maybeType.get
            val newType = coerced.cloneType()
            WeaveTypeCloneHelper.copyMetadataTo(coercedType, newType)
            Some(newType)
          }
        }
      }
      case TypeType(coercedType) => Some(coercedType)
      case _                     => None
    })
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    if (incomingExpectedType.isDefined) {
      node.incomingEdges().map((_, incomingExpectedType.get))
    } else {
      Seq()
    }
  }
}
