package org.mule.weave.v2.utils

import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.BinaryType
import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.DateTimeType
import org.mule.weave.v2.ts.LocalDateTimeType
import org.mule.weave.v2.ts.LocalDateType
import org.mule.weave.v2.ts.LocalTimeType
import org.mule.weave.v2.ts.NumberType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.StringType
import org.mule.weave.v2.ts.TimeType
import org.mule.weave.v2.ts.TimeZoneType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeTraverse

object WeaveTypeHelper {

  /**
    * Returns false if this type contains any complex object (an object with more than one kvp) otherwise returns true
    *
    * @param weaveType The type to check
    * @return True if not compex
    */
  def isSimpleType(weaveType: WeaveType): Boolean = {
    !WeaveTypeTraverse.exists(weaveType, {
      case ot: ObjectType => ot.properties.size > 1
      case _              => false
    })
  }

  /**
    *
    *
    * @param weaveType
    * @return
    */
  def createDefaultValueExpression(weaveType: WeaveType): String = {
    weaveType match {
      case _: StringType        => "\"\""
      case _: BooleanType       => "false"
      case _: NumberType        => "0"
      case _: ArrayType         => "[]"
      case _: ObjectType        => "{}"
      case _: BinaryType        => "\"\" as Binary"

      case _: DateTimeType      => "now()"
      case _: TimeType          => "now() as Time"
      case _: LocalTimeType     => "now() as LocalTime"
      case _: LocalDateType     => "now() as Date"
      case _: LocalDateTimeType => "now() as LocalDateTime"
      case _: TimeZoneType      => "now() as TimeZone"

      case _                    => ""

    }
  }

}
