package org.mule.weave.v2.utils

import org.mule.weave.v2.parser.ModuleParser
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.ts.ScopeGraphTypeReferenceResolver
import org.mule.weave.v2.ts.WeaveType

object WeaveTypeParser {

  def parse(typeText: String, parsingContext: ParsingContext, rootTypeName: String = "rootType___"): Option[WeaveType] = {
    val typeExpression = s"type ${rootTypeName} = ${typeText}"
    parseExpression(typeExpression, parsingContext)
  }

  def parseExpression(typeExpression: String, parsingContext: ParsingContext): Option[WeaveType] = {
    val value = ModuleParser.parse(ModuleParser.scopePhase(), WeaveResource("", typeExpression), parsingContext)
    if (value.hasResult()) {
      val astNode = value.getResult().astNode
      val typeDirective = astNode.elements.collect({
        case td: TypeDirective => td
      }).head
      Some(WeaveType(typeDirective.typeExpression, new ScopeGraphTypeReferenceResolver(value.getResult().scope)))
    } else {
      println(value.messages().errorMessageString())
      None
    }
  }

}
