package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child
import org.mule.weave.v2.parser.ast.NamedAstNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class NamespaceNode(var prefix: NameIdentifier) extends AstNode with NamedAstNode {

  override def children(): Seq[AstNode] = Child(prefix)

  override protected def doClone(): AstNode = {
    copy(prefix.cloneAst())
  }

  override def nameIdentifier: NameIdentifier = prefix

  override def getKind(): String = DWAstNodeKind.NAMESPACE_NODE
}

object NamespaceNode {
  val clazz: Class[NamespaceNode] = classOf[NamespaceNode]
}
