package org.mule.weave.v2.parser.ast.types

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode

case class TypeParametersListNode(var typeParameters: Seq[TypeParameterNode] = Seq()) extends AstNode {
  override def children(): Seq[AstNode] = typeParameters

  override protected def doClone(): AstNode = copy(typeParameters.map(_.cloneAst()))

  override def cloneAst(): TypeParametersListNode = super.cloneAst().asInstanceOf[TypeParametersListNode]

  override def getKind(): String = DWAstNodeKind.TYPE_PARAMETER_LIST_NODE
}
