package org.mule.weave.v2.parser.location

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

@WeaveApi(Seq("data-weave-agent"))
trait Location {
  def locationString: String
}

object Location {
  def apply(location: String) = new SimpleLocation(location)
}

@WeaveApi(Seq("data-weave-agent"))
class SimpleLocation(location: String) extends Location {
  override def locationString: String = location

}

object SimpleLocation {
  def apply(location: String): SimpleLocation = new SimpleLocation(location)
}

@WeaveApi(Seq("data-weave-agent"))
object UnknownLocation extends WeaveLocation(UnknownPosition, UnknownPosition, NameIdentifier.anonymous) {
  override def locationString: String = "Unknown location"
}

trait IndexedLocation extends Location {
  def index: Long
}