package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.NothingType
import org.mule.weave.v2.ts.ReferenceType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object ArrayTypeResolver extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    if (node.incomingEdges().isEmpty) {
      Some(ArrayType(NothingType()))
    } else {
      val arrayTypes: Seq[WeaveType] = node.incomingEdges().map(
        (item) => item.incomingType())
      Some(ArrayType(TypeHelper.unify(arrayTypes)))
    }
  }

  def resolveExpectedType(node: TypeNode, expectedType: WeaveType, ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    expectedType match {
      case arrayType: ArrayType => {
        node.incomingEdges().map((edge) => (edge, arrayType.of))
      }
      case rt: ReferenceType => {
        resolveExpectedType(node, Some(rt.resolveType()), ctx)
      }
      case ut: UnionType => {
        val weaveType = TypeHelper.resolveUnion(ut)
        weaveType match {
          case ut: UnionType => Seq()
          case _             => resolveExpectedType(node, weaveType, ctx)
        }
      }
      case _ => Seq()
    }
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    incomingExpectedType match {
      case Some(t) => {
        resolveExpectedType(node, t, ctx)
      }
      case _ => Seq()
    }
  }
}
