package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.ast.structure.NumberNode
import org.mule.weave.v2.ts.NumberType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object NumberTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    Some(NumberType(Some(node.astNode.asInstanceOf[NumberNode].literalValue)))
  }
}
