package org.mule.weave.v2.module.protobuf

import com.google.protobuf.DynamicMessage
import com.google.protobuf.InvalidProtocolBufferException
import com.google.protobuf.Message
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.protobuf.exception.ProtoBufParsingException
import org.mule.weave.v2.module.protobuf.utils.ProtoToDWConverter.protoMessageToDWValue
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.parser.location.UnknownLocation

import java.io.File
import java.nio.charset.Charset

class ProtoBufReader(source: SourceProvider, val settings: ProtoBufSettings, ctx: EvaluationContext) extends Reader {
  override protected def doRead(name: String): Value[_] = {
    try {
      val msg: Message = DynamicMessage.parseFrom(settings.messageDescriptor, source.asInputStream(ctx))
      protoMessageToDWValue(msg)
    } catch {
      case pe: InvalidProtocolBufferException =>
        throw new ProtoBufParsingException(pe.getMessage, UnknownLocation)
    }
  }

  override def dataFormat: Option[DataFormat[_, _]] = Some(new ProtoBufDataFormat())

}

object ProtoBufReader {
  def apply(file: File, encoding: String = "UTF-8", settings: ProtoBufSettings)(implicit ctx: EvaluationContext): ProtoBufReader = {
    new ProtoBufReader(SourceProvider(file, Charset.forName(encoding), ProtoBufDataFormat.defaultMimeType), settings, ctx)
  }
}
