/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.node;

import java.io.Serializable;
import java.util.Arrays;
import org.mule.weave.v2.interpreted.ExecutionContext;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.Types$;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.Value;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class FunctionDispatchingHelper$ {
    public static FunctionDispatchingHelper$ MODULE$;

    static {
        new FunctionDispatchingHelper$();
    }

    public Option<Tuple2<Object, FunctionValue>> findMatchingFunction(Value<Object>[] arguments, FunctionValue[] options, ExecutionContext ctx) {
        for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
            FunctionValue functionValue = options[optionIndex];
            boolean matchesTypes = this.matchesFunctionTypes(functionValue, arguments, ctx);
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)optionIndex), (Object)functionValue));
        }
        return None$.MODULE$;
    }

    public Option<Tuple3<Object, FunctionValue, Value<?>[]>> findMatchingFunctionWithCoercion(Value<Object>[] arguments, FunctionValue[] options, ExecutionContext ctx) {
        Value[] coercedValues = new Value[arguments.length];
        for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
            int index;
            FunctionValue function = options[optionIndex];
            if (function.minParams() > arguments.length || function.maxParams() < arguments.length) continue;
            boolean matchesTypes = true;
            FunctionParameter[] parameters = function.parameters();
            Seq functionParamTypes = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.wtype(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            for (index = 0; arguments.length > index && matchesTypes; ++index) {
                Type expectedType = (Type)functionParamTypes.apply(index);
                Type actualType = arguments[index].valueType((EvaluationContext)ctx);
                if (!actualType.isInstanceOf(expectedType, (EvaluationContext)ctx)) {
                    try {
                        coercedValues[index] = expectedType.coerce(arguments[index], (EvaluationContext)ctx);
                    }
                    catch (Exception e) {
                        matchesTypes = false;
                    }
                    continue;
                }
                coercedValues[index] = arguments[index];
            }
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)index), (Object)function, (Object)coercedValues));
        }
        return None$.MODULE$;
    }

    public FunctionValue[] sortByParameterTypeWeight(FunctionValue[] functionOverloads, Type[] argTypes, ExecutionContext ctx) {
        Tuple3[] weightFunctions = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functionOverloads)).map((Function1 & Serializable & scala.Serializable)operator -> {
            Type[] parameterTypes = (Type[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operator.parameters())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.wtype(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Type.class)));
            DoubleRef weight = DoubleRef.create((double)0.0);
            IntRef miss = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterTypes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])argTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)paramTypeArgType -> {
                FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$3(ctx, weight, miss, paramTypeArgType);
                return BoxedUnit.UNIT;
            });
            return new Tuple3(operator, (Object)BoxesRunTime.boxToDouble((double)weight.elem), (Object)BoxesRunTime.boxToInteger((int)miss.elem));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        FunctionValue[] sortedOperators = (FunctionValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])weightFunctions)).sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$4(v)), (Ordering)Ordering.Double$.MODULE$))).sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$5(v)), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)v -> (FunctionValue)v._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FunctionValue.class)));
        return sortedOperators;
    }

    public Option<Seq<Value<?>>> tryToCoerce(Seq<Value<?>> argumentsWithDefaults, FunctionValue dispatch, ExecutionContext ctx) {
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; dispatch.parameters().length > i; ++i) {
            ArrayBuffer arrayBuffer;
            Value value;
            Type expectedType = dispatch.parameters()[i].wtype();
            if (!expectedType.accepts(value = (Value)argumentsWithDefaults.apply(i), (EvaluationContext)ctx)) {
                Option valueMaybe = expectedType.coerceMaybe(value, (EvaluationContext)ctx);
                if (valueMaybe.isDefined()) {
                    arrayBuffer = result.$plus$eq(valueMaybe.get());
                    continue;
                }
                return None$.MODULE$;
            }
            arrayBuffer = result.$plus$eq((Object)value);
        }
        return new Some((Object)result);
    }

    public boolean matchesFunctionTypes(FunctionValue functionValue, Value<Object>[] arguments, ExecutionContext ctx) {
        return this.matchesParameters(functionValue.parameters(), functionValue.parameterTypes(), arguments, ctx);
    }

    public boolean matchesParameters(FunctionParameter[] parameters, Type[] paramTypes, Value<Object>[] arguments, ExecutionContext ctx) {
        boolean matchesTypes = true;
        if (parameters.length == arguments.length) {
            matchesTypes = Types$.MODULE$.validate(paramTypes, arguments, (EvaluationContext)ctx);
        } else if (arguments.length > parameters.length) {
            matchesTypes = false;
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).nonEmpty() && ((FunctionParameter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).head()).value().nonEmpty()) {
            int delta = parameters.length - arguments.length;
            FunctionParameter[] requireDefaultValue = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, 0, delta);
            FunctionParameter[] needsToCheck = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, delta, parameters.length);
            Type[] needsToCheckTypes = (Type[])Arrays.copyOfRange((Object[])paramTypes, delta, parameters.length);
            matchesTypes = this.validateDefaultValue(requireDefaultValue) && this.matchesParameters(needsToCheck, needsToCheckTypes, arguments, ctx);
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).nonEmpty() && ((FunctionParameter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).last()).value().nonEmpty()) {
            int delta = parameters.length - arguments.length;
            FunctionParameter[] requireDefaultValue = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, delta, parameters.length);
            FunctionParameter[] needsToCheck = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, 0, delta);
            Type[] needsToCheckTypes = (Type[])Arrays.copyOfRange((Object[])paramTypes, 0, delta);
            matchesTypes = this.validateDefaultValue(requireDefaultValue) && this.matchesParameters(needsToCheck, needsToCheckTypes, arguments, ctx);
        } else {
            matchesTypes = false;
        }
        return matchesTypes;
    }

    private boolean validateDefaultValue(FunctionParameter[] requireDefaultValue) {
        for (int i = 0; i < requireDefaultValue.length; ++i) {
            if (!requireDefaultValue[i].value().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final Value<?>[] expandArguments(Value<?>[] arguments, FunctionValue function, ExecutionContext ctx) {
        Value<?>[] valueArray;
        FunctionParameter[] parameters = function.parameters();
        if (arguments.length != parameters.length) {
            Seq paramsWithIndex = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            valueArray = ((FunctionParameter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).head()).value().isDefined() ? this.expandArgsFromHead((Seq<Tuple2<FunctionParameter, Object>>)paramsWithIndex, arguments, ctx) : this.expandArgsFromTail((Seq<Tuple2<FunctionParameter, Object>>)paramsWithIndex, arguments, ctx);
        } else {
            valueArray = arguments;
        }
        return valueArray;
    }

    private Value<?>[] expandArgsFromHead(Seq<Tuple2<FunctionParameter, Object>> paramsWithIndex, Value<?>[] arguments, ExecutionContext ctx) {
        int paramsCount = paramsWithIndex.length();
        return (Value[])((TraversableOnce)paramsWithIndex.map((Function1 & Serializable & scala.Serializable)param -> {
            Value value;
            int delta;
            int index = param._2$mcI$sp();
            if (index < (delta = paramsCount - arguments.length)) {
                Value v;
                Option defaultValue = ((FunctionParameter)param._1()).value().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value((EvaluationContext)ctx));
                Option option = defaultValue;
                if (!(option instanceof Some)) {
                    throw new RuntimeException("Please verify function arity before trying to expand");
                }
                Some some = (Some)option;
                Value value2 = v = (Value)some.value();
                value = value2;
            } else if (index < paramsCount) {
                value = arguments[index - delta];
            } else {
                throw new RuntimeException("Please verify function arity before trying to expand");
            }
            return value;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Value.class));
    }

    private Value<?>[] expandArgsFromTail(Seq<Tuple2<FunctionParameter, Object>> paramsWithIndex, Value<?>[] arguments, ExecutionContext ctx) {
        return (Value[])((TraversableOnce)paramsWithIndex.map((Function1 & Serializable & scala.Serializable)param -> {
            Value value;
            int index = param._2$mcI$sp();
            if (index < arguments.length) {
                value = arguments[index];
            } else {
                Value v;
                Option defaultValue = ((FunctionParameter)param._1()).value().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.value((EvaluationContext)ctx));
                Option option = defaultValue;
                if (!(option instanceof Some)) {
                    throw new RuntimeException("Please verify function arity before trying to expand");
                }
                Some some = (Some)option;
                Value value2 = v = (Value)some.value();
                value = value2;
            }
            return value;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Value.class));
    }

    public static final /* synthetic */ void $anonfun$sortByParameterTypeWeight$3(ExecutionContext ctx$1, DoubleRef weight$1, IntRef miss$1, Tuple2 paramTypeArgType) {
        block0: {
            if (((Type)paramTypeArgType._2()).isInstanceOf((Type)paramTypeArgType._1(), (EvaluationContext)ctx$1)) break block0;
            ++miss$1.elem;
            weight$1.elem += (double)((Type)paramTypeArgType._1()).weight();
        }
    }

    public static final /* synthetic */ double $anonfun$sortByParameterTypeWeight$4(Tuple3 v) {
        return BoxesRunTime.unboxToDouble((Object)v._2());
    }

    public static final /* synthetic */ int $anonfun$sortByParameterTypeWeight$5(Tuple3 v) {
        return BoxesRunTime.unboxToInt((Object)v._3());
    }

    private FunctionDispatchingHelper$() {
        MODULE$ = this;
    }
}

