package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.structure.Namespace
import org.mule.weave.v2.model.types.NamespaceType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.exception.InvalidNamespacePrefixException

class NamespaceNode(val prefix: NameSlot) extends ValueNode[Namespace] with Product1[NameSlot] {
  override def doExecute(implicit ctx: ExecutionContext): Value[Namespace] = {
    val v = if (prefix.module.isDefined) {
      val moduleName: NameSlot = prefix.module.get
      ctx.executionStack().getVariable(moduleName.slot, prefix.slot)
    } else {
      ctx.executionStack().getVariable(prefix.slot)
    }
    if (v != null) {
      NamespaceType.coerce(v, this)
    } else {
      throw new InvalidNamespacePrefixException(location(), prefix.name)
    }
  }

  override def _1: NameSlot = prefix
}

object NamespaceNode {
  def apply(prefix: NameSlot) = new NamespaceNode(prefix)
}